#!/usr/bin/perl
use strict; # always use strict
#use warnings;
use XML::Simple;
#use Data::Dumper;

my @resultat;  #tableau de message à rentrer dans le fichier
my $info=0;  #variable de trie des information à rentrer dans les résusltat
my @niveau;
my $index_niveau=0;  # ces 2 variables permettent de connaitre le niveau d'itération en cours
# gestion des paramètre
my $titre=0;  #affiche la ligne de titre
my $colonne=0;  #affiche la colonne de numérotation
my $attr=0;  #sortie complète avec attribut
my $fichierXML;  #nom du fichier d'entrée
my $fichierTXT;  #nom du fichier de sorite
my $dossier;  #demande de traitement d'un dossier complet
my $type=0;  #défini si la ligne de titre doit être complétée par le niveau supérieur

#traitement des structures tableau
sub tableau{
  my $liste=$_[0];  #récupération de l'argument
  my $index=-1;  #index pour naviguer dans le tableau argument
  my $info_tmp=$info;
  foreach (@$liste)
  {
    #gestion du niveau d'itération
    $niveau[$index_niveau]++;
    if($index_niveau==1)
    {
      chop($resultat[1]);
      if($colonne==1)
      {
	  $resultat[1].="\n$niveau[$index_niveau],";
      }
      else
      {
	  $resultat[1].="\n";
      }
    }
    $index++;
    #traitement des données du tableau
    my $tmp1=$$liste[$index];
    if(ref($tmp1) eq "ARRAY")
    {
      $info=$info_tmp;
      $index_niveau++;
      tableau($tmp1);
      $index_niveau--;
    }
    if(ref($tmp1) eq "HASH")
    {
      $info=$info_tmp;
      $index_niveau++;
      hash_table($tmp1);
      $index_niveau--;
    }
  }
  $info=0;
}

#traitement des structures table de hachage
sub hash_table{
  my $ht=$_[0];
  foreach my $k (keys(%$ht))
  {
    #gestion du niveau d'itération
    $niveau[$index_niveau]++;
    if($index_niveau==1)
    {
      chop($resultat[1]);
     if($colonne==1)
      {
	  $resultat[1].="\n$niveau[$index_niveau],";
      }
      else
      {
	  $resultat[1].="\n";
      }
    }
    my $tmp1=$$ht{$k};
    #traitement des données de la table de hachage
    if(ref($tmp1) eq "ARRAY")
    {
      $info=1;
      $index_niveau++;
      tableau($tmp1);
      $index_niveau--;
    }
    if(ref($tmp1) eq "HASH")
    {
      $info=1;
      $index_niveau++;
      hash_table($tmp1);
      if($type==1)
      {
	$resultat[0].="$k,";
	$type=0;
      }
      $index_niveau--;
    }
    if(!ref($tmp1)&&$info==1)
    {
	if ($attr==0)
	{
	    if($k eq "content")
	    {
	      $resultat[1].="$$ht{$k},";
	      if($niveau[1]==1) #traitement des clés uniquement pour le premier élément pour crée une ligne de titre
	      {
		if(exists($$ht{'type'}))
		{
		  $resultat[0].="$$ht{'type'},";
		}
		else
		{
		  $type=1;
		}
	      }
	    }
	}
	else
	{
	    $resultat[1].="$$ht{$k},";
	    if($niveau[1]==1) #traitement des clés uniquement pooour le premier élément pour crée une ligne de titre
	    {
	      $resultat[0].="$k,";
	    }
	}
    }    
  }
  $info=0;
}

sub principal
{
  my $parser = XML::Simple->new(ForceContent => 1);  #création du parser
  my $doc = $parser->XMLin($fichierXML);  #création de la structure de données issue du fichier XML
  my $fichier=open(F1,">$fichierTXT")or die("open: $!");  #fichier de sortie
  hash_table($doc);  #traitement de la structure de données
  #traitement final de la ligne de titre
  if($colonne==1)
  {
    $resultat[0]="Numéro,$resultat[0]";
  }
  if($titre==1)
  {
    chop($resultat[0]);
    $resultat[0].="\n";
    print (F1 "$resultat[0]");
  }
  #traitement final des élément à resortir
  chop($resultat[1]);
  $resultat[1]=reverse($resultat[1]);
  chop($resultat[1]);
  $resultat[1]=reverse($resultat[1]);
  #intégration dans le fichier
  print (F1 "$resultat[1]");
  close(F1);
}

#initialisation pour fonctionnement en boucle
sub init
{
  @resultat=undef;
  @niveau=undef;
}

#générer les nom de fichier d'entré et de sortie
sub nomFichier
{
  my $adresse=$_[0];
  $fichierXML=$adresse;
  my $i=0;
  my @char;
  my $char;
  for($char=chop($adresse);!($char eq "/")&&!($char eq "");$char=chop($adresse))
  {
      $char[$i]=$char;
      $i+=1;
  }
  $adresse.=$char;
  $fichierTXT=$adresse."resultat/";
  if(!(-e $fichierTXT))
  {
    open(tmp,"|mkdir ".$fichierTXT);
    close(tmp);
  }
  my $chemin=$fichierTXT;
  for(;$i>=0;$i-=1)
  {
      $fichierTXT.=$char[$i];
  }
  $fichierTXT.=".txt";
  return $chemin;
}

#traitement du tableau de paramètre
foreach my $a (@ARGV)
{
  if($a eq "t")  #recherche du paramètre concernant la ligne de titre
  {
    $titre=1;
  }
  elsif($a eq "c")  #recherche du paramètre concernant la colonne de numérotation
  {
    $colonne=1;
  }
  elsif($a eq "a")  #recherche du paramètre concernant le traitement des attributs XML
  {
    $attr=1;
  }
  elsif($a =~ m/\.xml$/ || $a =~ m/\.XML$/)  #recherche du paramètre consernant le fichier d'entrée (extention en minuscule)
  {
    nomFichier($a);
  }
  elsif(-e $a)  #recherche du paramètre pour traiter un dossier complet
  {
    $dossier=$a;
    my $len=length($dossier);
    if (substr($dossier,$len-1,1) ne "/")
    {
      $dossier.="/";
    }
  }
  else   #Afficher une erreur si un argument et invalide
  {
    print "ERREUR2 : il faut rentrer le nom d'un fichier XML valide\n";
    exit;
  }
}
#forcer le mode traitement du dossier courant si rien n'est précisé
if (!(defined ($dossier))&&!(defined ($fichierTXT)))
{
  $dossier="./";
}

if (defined ($dossier))
{
  my @liste=(<$dossier*.xml>,<$dossier*.XML>);
  foreach my $a (@liste)
  {
    nomFichier($a);
    principal();
    init();
  }
}
else
{
  principal();
}
close(tmp);

=head1 NOM

B<I<xml2txt.pl>> - Transforme les livres d'atomes XML de MPTK en fichiers text exploitables par d'autres logiciels.

=head1 SYNOPSIS

B<xml2txt.pl> [t] [c] [a] [I<fichierXML>] [I<repertoire>]

=head1 DESCRIPTION

Sans argument cette commande traite l'intgralit des fichiers XML du rpertoire courant. Les fichiers rsultats sont gnrs dans un rpertoire I<resultat>  l'adresse du ou des fichiers XML traits. Ces fichiers portent le mme nom que le fichier XML plus l'extension I<txt>

Les options suivantes sont possibles :

=over 6

=item t

Intgre une ligne de titre pour un traitement par tableur par exemple.

=item c

Intgre une colonne de numrotation pour un traitement par tableur par exemple.

=item a

Permet de traiter les attributs de balise XML en plus du contenu des balises.

=item I<fichierXML>

permet de ne traiter qu'un seul fichier. Il peut tre indiqu en adresse relative ou absolu. La gnration du rsultat rpond aux mmes rgles que dites prcedemment. Cette option ne peut tre utilise qu'une seul fois.

=item I<repertoire>

permet de traiter un rpertoire autre que le rpertoire courant. La gnration des rsultats rpond aux mmes rgles que dites prcedemment. Cette option ne peut tre utilise qu'une seul fois et sans la prcdente.

=back

L'ordre des options est indiffrent.

=head1 AUTEUR

Franck LAURENT et Florian GOUDEY pour Christian GUILLEMINOT